;This is a program is the second program exercise for Chapter 12 of MCU Programming for 
;Beginners text.  The program sets up the comparator resources with the comparator output
;not connected to RA2, a voltage divider tied to RA0 (the + comparator input)
;and a varible resistor tied to RA1.  LEDs are tied to RC3 and RC4 for indicators.  
;When the variable resistor is adjusted to change the voltage on RA1, the comparator output
;is read by software the appropriate LED (for voltage below or above the reference voltage 
;tied to RA0).  The main part of the program is simply a goto loop. 



	list      p=16F676       ; list directive to define processor
	#include <p16f676.inc>    ; processor specific variable definitions



	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF
;	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _HS_OSC & _MCLRE_OFF & _CPD_OFF
; '__CONFIG' directive is used to embed configuration word within .asm file.
; The labels following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.

;******************************************************************************
;Defines
;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80


;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
		count		;used in delay routines
		tempa
	endc


;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000         	; processor reset vector
	nop						; required by in circuit debugger  
	goto    Init            ; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG	0x004
	;goto interupt_service
	return			; interrupt trap - returns without re-enabling
;******************************************************************************
;Initialization
;******************************************************************************
Init
	BANKSEL Bank1
	call    0x3FF      ; retrieve factory calibration value
	movwf	OSCCAL

	BANKSEL	Bank0		;select bank0
	clrf	PORTA		;clear port bus
	clrf	PORTC		;clear port bus

	movlw	b'00000010'	;comparator with non inverted output,
						;+/- inputs connected CM2:CM0 = 010,
						;COUT not connected to RA2, must be read in software


;	movlw	b'00010010'	;comparator with inverted output


	movwf	CMCON		;
	movlw	b'00000000'	;load w reg
	movwf	INTCON
	BANKSEL	Bank1		; BANK1
	movlw	b'00000000'	;load w reg  
	movwf	OPTION_REG	;put w reg into option register
	movlw	b'00000011'	;load w reg, RA0 and RA1 input, others output 
	movwf	TRISA		;program PORTA
	movlw	b'00000000'	;load w reg all output
	movwf	TRISC		;program PORTC
	movlw	b'00000011'	;RA0, RA1 is analog, all other digital
	movwf	ANSEL		
	BANKSEL	Bank0		;back to bank0
	
;end pic initialization

;*****************************************************************************
;main program
main
	btfsc	CMCON,COUT	;sense CMCON,COUT bit, if clear skip next
	goto	flash_RC3	;if set do this goto
	goto	flash_RC4
	
	goto main

flash_RC3
	bsf		PORTC,3
	call	wait250mS
	bcf		PORTC,3
	call	wait250mS
	goto	main

flash_RC4
	bsf		PORTC,4
	call	wait50mS
	bcf		PORTC,4
	call	wait50mS
	goto	main

;*****************************************************************************

;Delay Routines
;******************************************************************************
;more delay options than needed, this is standard delay code I use in other programs
wait5sec
		call	wait1sec
		call	wait1sec
		call	wait1sec
		call	wait1sec		;1 seconds plus the one to follow
		

wait1sec
		call	wait300mS
		call	wait300mS
		call	wait300mS
		goto	wait100mS
wait300mS
        call    delay50mS
wait250mS
        call    delay50mS
        call    delay50mS
        call    delay50mS
wait100mS
        call    delay50mS
wait50mS
        call    delay50mS
		return
;delay1ms, is a very accurate 1mS delay for a 4Mhz clock.
delay1mS
        movlw   .198
        movwf   count
        nop
        goto    $+1
        goto    $+1
dly1mS        
        goto    $+1
        decfsz  count, F
        goto    dly1mS
        return
;delay5mS uses delay1mS to get a very accurate 5 mS delay
delay5mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        movlw   .4
        movwf   count
tweek5mS
        decfsz  count, F
        goto    tweek5mS
        return
;delay50mS uses delay1mS to get a very accurate 50mS delay
delay50mS
        movlw   .50
        movwf   tempa
dly50mS
        call    delay1mS
        decfsz  tempa, F
        goto    dly50mS
        movlw   .14
        movwf   count
tweek50mS
        decfsz  count, F
        goto    tweek50mS
        return
;delay200mS uses delay1mS to get a very accurate 200mS delay.
delay200mS
        movlw   .200
        movwf   tempa
dly200mS
        call    delay1mS
        decfsz  tempa, F
        goto    dly200mS
        movlw   .64
        movwf   count
tweek200mS
        decfsz  count, F
        goto    tweek200mS
        return

bitdelay

		movlw	.30				;this number works if the user uses the calbrated
								;value for the internal clock. This routine, including
								;the goto and nop statements below allow the user to develop
								;an anticipated delay of 100uS for the bits at 9600 Baud.
								;This delay can be verified by using the stop watch function
								;of MPLab Simulator 
		movwf	count
		goto    $+1				;these goto statements allow you tweek the time of the
		goto	$+1				;delay.  Goto statements like this take 2 clock cycles
		nop						;while the nop statement takes 1 clock cycle to complete


bit
		decfsz	count, f
		goto	bit
		return
;end delay rountines



	end
